import json
import os
import fire
import re

def convert_to_llava(input_file, output_file):
    anno = json.load(open(input_file, "r"))
    target_format = []
    if "annotations" in anno:
        anno = anno["annotations"]
    for item_id, item in enumerate(anno):
        image_id = item['image_id']
        if not image_id.endswith(".jpg"):
            image_id += ".jpg"
        target_format.append({
            "id": item_id,
            "image": image_id,
            "conversations": [
                {'from': 'human', 'value': f"describe the image with as many details as possible.\n<image>"},
                {'from': 'gpt', 'value': f"{item['caption']}"},
            ],
        })

    print(f'Number of samples: {len(target_format)}')

    with open(output_file, "w") as f:
        json.dump(target_format, f, indent=2)


def main(task, **kwargs):
    globals()[task](**kwargs)


if __name__ == "__main__":
    fire.Fire(main)
